#include <algorithm>
#include <iostream>
#include <sstream>
#include <vector>
#include <string>
#include <set>
#include <map>
#include <iterator>
#include <cmath>
#include <cstdlib>
#include <cstdio>
#include <cstring>
#include <cctype>

using namespace std;

#define FOR(i, a, b) for (int i = (a); i < (b); ++i)
#define ROF(i, a, b) for (int i = (b) - 1; i >= (a); --i)

typedef pair <int, int> pii;
typedef long long LL;
typedef LL ll;

const int INF = 1000000000;
const LL LINF = (LL) INF * (LL) INF;

struct Edge {
  int b, f, c;
  Edge* next;
  Edge* back;
  pii output;
};
Edge ea[350000];
int nea = 0;
Edge* ealloc(int b, int f, int c, Edge* next) {
  ea[nea].b = b; ea[nea].f = f; ea[nea].c = c; ea[nea].next = next;
  return &ea[nea++];
}

const int MAXN = 65536;
Edge* ve[MAXN];
Edge* add(int a, int b, int f) {
  ve[a] = ealloc(b, f, 0, ve[a]);
  ve[b] = ealloc(a, 0, 0, ve[b]);
  ve[a]->back = ve[b];
  ve[b]->back = ve[a];
  return ve[a];
}

int S = 0;
int T = 1;
int vi[64];
int N;

const int MAXK = 110;

int s, t;
int prevk = 0;

int vq[MAXN];
int vis[MAXN];
int vd[MAXN];
Edge* vp[MAXN];

bool can(int k, int r) {
  {
    Edge* e = ve[vi[t] + prevk];
    ve[vi[t] + prevk] = e->next;
    e->next = ve[vi[t] + k];
    ve[vi[t] + k] = e;
    ve[T]->b = vi[t] + k;
    prevk = k;
  }

  FOR(i, 0, nea) ea[i].c = 0;

  while (true) {
    FOR(i, 0, N) vis[i] = 0, vp[i] = NULL, vd[i] = 0;
    int qh = 0, qt = 0;

    vq[qh++] = S;
    vis[S] = 1;
    vd[S] = 1000000;
    while (qh > qt) {
      int v = vq[qt++];
      for (Edge* e = ve[v]; e; e = e->next) {
        if (e->c < e->f && !vis[e->b]) {
          vis[e->b] = 1;
          vd[e->b] = min(vd[v], e->f - e->c);
          vp[e->b] = e;
          vq[qh++] = e->b;
        }
      }
    }
    if (!vp[T]) {
      break;
    }
    int d = vd[T];
    int cur = T;
    while (cur != S) {
      vp[cur]->c += d;
      vp[cur]->back->c -= d;
      cur = vp[cur]->back->b;
    }
  }
  return ve[S]->c >= r;
}

vector<pii> output[MAXK];

void dfs(int v, int ship, int prev) {
  for (Edge* e = ve[v]; e; e = e->next) {
    if (e->b == T) return;
    if (e->c <= 0) continue;
    if (e->output.first > 0 && e->output.first != prev) {
      output[e->output.second].push_back(pii(ship, e->output.first));
      prev = e->output.first;
    }
    e->c--;
    dfs(e->b, ship, prev);
    return;
  }
}

int main() {
  int n, m, k;
  scanf("%d%d%d%d%d", &n, &m, &k, &s, &t);
  s--, t--;
  vi[0] = 2;
  FOR(i, 1, n) {
    vi[i] = vi[i - 1] + MAXK + 1;
  }
  N = 2 + n * (MAXK + 1);
  FOR(i, 0, n) {
    FOR(j, 0, MAXK) {
      add(vi[i] + j, vi[i] + j + 1, 1000000);
    }
  }
  FOR(i, 0, m) {
    int a, b;
    scanf("%d%d", &a, &b); a--, b--;
    FOR(j, 0, MAXK) {
      int f = N;
      N += 2;
      add(vi[a] + j, f, 1);
      add(vi[b] + j, f, 1);
      add(f, f + 1, 1);
      add(f + 1, vi[a] + j + 1, 1)->output = pii(a + 1, j);
      add(f + 1, vi[b] + j + 1, 1)->output = pii(b + 1, j);
    }
  }
  add(S, vi[s], 1000000);
  add(vi[t], T, 1000000);

  int Left = 0;
  int Right = MAXK;
  while (Left < Right) {
    int Mid = (Left + Right) / 2;
    if (can(Mid, k)) {
      Right = Mid;
    } else {
      Left = Mid + 1;
    }
  }

  can(Left, k);
  FOR(i, 0, k) {
    dfs(vi[s], i + 1, s + 1);
  }

  printf("%d\n", Left);
  FOR(i, 0, Left) {
    printf("%d", output[i].size());
    FOR(j, 0, output[i].size()) {
      printf("  %d %d", output[i][j].first, output[i][j].second);
    }
    printf("\n");
  }

  return 0;
}
